﻿using System.Collections.Generic;

namespace Eliza
{
    /// <summary>
    /// A rule that associates decomposition of an input string with a collection of
    /// reassembled responses.
    /// </summary>
    class DecompReassemblyRule
    {
        #region Constructor

        /// <summary>
        /// Initializes a new instance of the <see cref="DecompReassemblyRule"/> class.
        /// </summary>
        /// <param name="decomp">How the input string should be decomposed.</param>
        /// <param name="reassembledResponses">The reassembled responses.</param>
        public DecompReassemblyRule
            (string decomp,
             List<string> reassembledResponses)
        {
            this._decomp = decomp;
            this._reassembledResponses = new List<string>();
            foreach(string reassembledResponse in reassembledResponses) {
                this._reassembledResponses.Add(reassembledResponse);
            }
            this._nextResponseIndex = 0;
        }

        #endregion

        #region Public methods

        /// <summary>
        /// Determines whether this instance can decompose the specified input.
        /// </summary>
        /// <param name="input">The input.</param>
        /// <returns>
        /// <see langword="true"/> if this instance can decompose the specified input; otherwise,
        /// <see langword="false"/>.
        /// </returns>
        public bool CanDecompose
            (string input)
        {
            // Stubbed for now
            return true;
        }

        /// <summary>
        /// Generates a response to the user's input.
        /// </summary>
        /// <param name="input">The user's input.</param>
        /// <returns>
        /// The response.
        /// </returns>
        public string GenerateResponse
            (string input)
        {
            return "I LOVE MASALA DOSAS.";
        }

        #endregion

        #region Fields

        /// <summary>
        /// How the input string should be decomposed.
        /// </summary>
        private string _decomp;

        /// <summary>
        /// The collection of reassembled responses.
        /// </summary>
        private List<string> _reassembledResponses;

        /// <summary>
        /// Index of the next reassembled response to return.
        /// </summary>
        private int _nextResponseIndex;

        #endregion
    }
}
